log using EJPR_AyoubKollman_logfile_06302020.log, replace
set more off 
use "EJPR_AyoubKollman_data_06302020", clear

*** Random Effects Logistic Regression misstable summarize
	tsset id_country time1
	replace execrlc = L.execrlc if execrlc >= .
	forvalues i = 1/14 {
		replace execrlc = execrlc[_n+1] if execrlc >= .
	}
	misstable summarize
	replace system = L.system if system >= .
		forvalues i = 1/13 {
	replace system = F.system if system >= .
	}

*** Table 3 Update: DV: LGBTI policy IVs: Exclude SMOs
	xtset id_country year,yearly
	
    *** SSU
	xtlogit SSU urbanization2 execrlc gdp_percap i.time1
    margins, dydx (urbanization2 execrlc gdp_percap)
	
	xtlogit SSU urbanization2 execrlc gdp_percap excomm_state total_ssu_world i.time1
    margins, dydx (urbanization2 execrlc gdp_percap excomm_state total_ssu_world)
	
	xtlogit SSU urbanization2 execrlc gdp_percap excomm_state total_ssu_world ib2.religion_state i.time1
    margins, dydx (urbanization2 execrlc gdp_percap ib2.religion_state excomm_state total_ssu_world)
	
    *** Marriage
	xtlogit marriage urbanization2 execrlc gdp_percap i.time1
    margins, dydx (urbanization2 execrlc gdp_percap)
	
	xtlogit marriage urbanization2 execrlc gdp_percap excomm_state total_marriage_world i.time1
    margins, dydx (urbanization2 execrlc gdp_percap excomm_state total_marriage_world)
	
	xtlogit marriage urbanization2 execrlc gdp_percap excomm_state total_marriage_world ib2.religion_state i.time1
    margins, dydx (urbanization2 execrlc gdp_percap ib2.religion_state excomm_state total_marriage_world)
	
	**Anti-discrimination
	xtlogit anti_discrimination urbanization2 execrlc gdp_percap i.time1
	margins, dydx (urbanization2 execrlc gdp_percap)
    
	xtlogit anti_discrimination urbanization2 execrlc gdp_percap excomm_state euaccession i.time1
    margins, dydx (urbanization2 execrlc gdp_percap euaccession excomm_state)
	
	xtlogit anti_discrimination urbanization2 execrlc gdp_percap excomm_state euaccession ib2.religion_state i.time1
    margins, dydx (urbanization2 execrlc gdp_percap ib2.religion_state euaccession excomm_state)

*** Table 4 
    *** DV SMOs(0/1)
		xtlogit LGBT_orgs_ilga_01 urbanization2 execrlc gdp_percap i.time1
	    margins, dydx (urbanization2 execrlc gdp_percap)
	    
		xtlogit LGBT_orgs_ilga_01 urbanization2 execrlc gdp_percap excomm_state total_ssu_world i.time1
        margins, dydx (urbanization2 execrlc gdp_percap excomm_state total_ssu_world)
	    
	*** DV LGBTI policy IVs: Include SMOs
	    xtlogit SSU urbanization2 europe_lgbt_orgs_ilga i.time1
        margins, dydx (urbanization2 europe_lgbt_orgs_ilga)
		
		xtlogit SSU urbanization2 europe_lgbt_orgs_ilga execrlc gdp_percap excomm_state total_ssu_world i.time1
        margins, dydx (urbanization2 europe_lgbt_orgs_ilga execrlc gdp_percap excomm_state total_ssu_world)
	 
		xtlogit anti_discrimination urbanization2 europe_lgbt_orgs_ilga i.time1
		margins, dydx (urbanization2 europe_lgbt_orgs_ilga )
        
		xtlogit anti_discrimination urbanization2 europe_lgbt_orgs_ilga execrlc gdp_percap excomm_state euaccession i.time1
        margins, dydx (urbanization2 europe_lgbt_orgs_ilga execrlc gdp_percap euaccession excomm_state)
      
*** Table A3. Cox Robustness Check (Includes SMOs), add to Table A3
	stset time1, failure (registered_partnership)
    stcox urbanization2, vce(cluster id_country)
	
	stset time1, failure (marriage)
    stcox urbanization2, vce(cluster id_country)
	
	stset time1, failure (SSU)
    stcox urbanization2, vce(cluster id_country)
	
	stset time1, failure (anti_discrimination)
    stcox urbanization2, vce(cluster id_country)
	
	stset time1, failure (europe_lgbt_orgs_ilga)
    stcox urbanization2, vce(cluster id_country)

*** Descriptive Stats and Correlations Quantitative IVs: urbanization2, SMOs, population
    summ urbanization2 europe_lgbt_orgs_ilga population gdp_percap total_ssu_world log_gdp_percap log_urbanization2 
    corr urbanization2 europe_lgbt_orgs_ilga population gdp_percap total_ssu_world

set more on
log close 
